using System;
using System.Data;
using System.Data.Common;
using System.Collections.Generic;
using System.Text;

namespace ConnBuilder
{
   class Program
   {
      static void Main(string[] args)
      {
         DataTable factories = DbProviderFactories.GetFactoryClasses();
         foreach (DataRow row in factories.Rows)
         {
            if ((string)row["InvariantName"] != "Microsoft.SqlServerCe.Client")
            {
               DbProviderFactory factory =
                  DbProviderFactories.GetFactory((string)row["InvariantName"]);
               DbConnectionStringBuilder connBuilder =
                  factory.CreateConnectionStringBuilder();
               connBuilder.Add("server", "localhost");
               connBuilder.Add("user", "sa");
               connBuilder.Add("password", "secret");
               connBuilder.Add("data source", "SampleDB");
               Console.WriteLine("[{0}] {1}",
                  row["InvariantName"],
                  connBuilder.ConnectionString);
            }
         }
         Console.ReadLine();
      }
   }
}
